#include <WiFi.h>
#include <WebServer.h>
#include <WebSocketsServer.h>
#include "XLOTMIDI.h"

const char* ssid = "XLOT-Piano";
const char* password = "12345678";

WebServer server(80);
WebSocketsServer ws(81);

XLOT_MIDI synth;
#define UART_TX_PIN         18                    // 主控 TX → XLOTMIDI RX  (绿色线/Green Wire)XLOT-Hermes→18 XLOT-Nova→4 XLOT-MiniC6→2 
#define UART_RX_PIN         17                    // 主控 RX → XLOTMIDI TX  （黄色线/Yellow Wire）XLOT-Hermes→17 XLOT-Nova→1 XLOT-MiniC6→1

// ---------------- HTML ----------------
const char INDEX_HTML[] PROGMEM =
"<!DOCTYPE html><html><head><meta charset='UTF-8'>"
"<title>XLOT Web Piano</title>"
"<style>"
"body{margin:0;background:#222;color:#eee;font-family:Arial;}"
"#top{background:#333;padding:10px;display:flex;align-items:center;gap:10px;}"
"select,input[type=range]{font-size:16px;padding:4px;}"
"#wrap{overflow-x:scroll;background:#111;height:240px;}"
"#piano{width:4400px;height:220px;position:relative;}"

".white{width:40px;height:200px;background:#fff;display:inline-block;"
"border:1px solid #000;position:relative;vertical-align:top;}"
".white.active{background:#88c;}"

".black{width:26px;height:120px;background:#000;position:absolute;left:28px;top:0;"
"z-index:10;border-radius:3px;border:1px solid #222;}"
".black.active{background:#55f;}"

".label{position:absolute;bottom:5px;width:100%;text-align:center;font-size:12px;color:#000;}"
"</style></head><body>"

"<div id='top'>"
"<label>乐器：</label><select id='prog' onchange='setProg()'></select>"
"<label>音量：</label><input id='vol' type='range' min='0' max='127' value='100' oninput='setVol()'>"
"<button onclick='panic()'>Panic</button>"
"</div>"

"<div id='wrap'><div id='piano'></div></div>"

"<script>"
"let ws=new WebSocket('ws://'+location.hostname+':81/');"
"function send(m){ws.send(m);} "
"function panic(){send('PANIC');}"

// ----------- 128 GM 乐器完整列表 -----------
"let names=["
"\"0 Acoustic Grand Piano 原声大钢琴\","
"\"1 Bright Acoustic Piano 明亮钢琴\","
"\"2 Electric Grand Piano 电钢琴\","
"\"3 Honky-tonk Piano 酒吧钢琴\","
"\"4 Electric Piano 1 电钢琴1\","
"\"5 Electric Piano 2 电钢琴2\","
"\"6 Harpsichord 羽管键琴\","
"\"7 Clavinet 拨弦键琴\","

"\"8 Celesta 钢片琴\","
"\"9 Glockenspiel 钟琴\","
"\"10 Music Box 八音盒\","
"\"11 Vibraphone 颤音琴\","
"\"12 Marimba 马林巴\","
"\"13 Xylophone 木琴\","
"\"14 Tubular Bells 管钟\","
"\"15 Dulcimer 扬琴\","

"\"16 Drawbar Organ 音栓风琴\","
"\"17 Percussive Organ 打击风琴\","
"\"18 Rock Organ 摇滚风琴\","
"\"19 Church Organ 教堂风琴\","
"\"20 Reed Organ 簧管风琴\","
"\"21 Accordion 手风琴\","
"\"22 Harmonica 口琴\","
"\"23 Tango Accordion 探戈手风琴\","

"\"24 Acoustic Guitar (nylon) 尼龙吉他\","
"\"25 Acoustic Guitar (steel) 钢弦吉他\","
"\"26 Electric Guitar (jazz) 爵士电吉他\","
"\"27 Electric Guitar (clean) 清音电吉他\","
"\"28 Electric Guitar (muted) 闷音电吉他\","
"\"29 Overdriven Guitar 破音吉他\","
"\"30 Distortion Guitar 失真吉他\","
"\"31 Harmonics 吉他泛音\","

"\"32 Acoustic Bass 原声贝斯\","
"\"33 Fingered Bass 手指贝斯\","
"\"34 Picked Bass 拨片贝斯\","
"\"35 Fretless Bass 无品贝斯\","
"\"36 Slap Bass 1 打弦1\","
"\"37 Slap Bass 2 打弦2\","
"\"38 Synth Bass 1 合成贝斯1\","
"\"39 Synth Bass 2 合成贝斯2\","

"\"40 Violin 小提琴\","
"\"41 Viola 中提琴\","
"\"42 Cello 大提琴\","
"\"43 Contrabass 低音提琴\","
"\"44 Tremolo Strings 颤音弦乐\","
"\"45 Pizzicato Strings 拨弦乐\","
"\"46 Harp 竖琴\","
"\"47 Timpani 定音鼓\","

"\"48 String Ensemble 1 弦乐合奏1\","
"\"49 String Ensemble 2 弦乐合奏2\","
"\"50 Synth Strings 1 合成弦乐1\","
"\"51 Synth Strings 2 合成弦乐2\","
"\"52 Choir Aahs 合唱啊音\","
"\"53 Voice Oohs 人声呜音\","
"\"54 Synth Choir 合成人声\","
"\"55 Orchestra Hit 管弦敲击\","

"\"56 Trumpet 小号\","
"\"57 Trombone 长号\","
"\"58 Tuba 大号\","
"\"59 Muted Trumpet 闷音小号\","
"\"60 French Horn 法国号\","
"\"61 Brass Section 铜管组\","
"\"62 Synth Brass 1 合成铜管1\","
"\"63 Synth Brass 2 合成铜管2\","

"\"64 Soprano Sax 高音萨克斯\","
"\"65 Alto Sax 中音萨克斯\","
"\"66 Tenor Sax 次中音萨克斯\","
"\"67 Baritone Sax 低音萨克斯\","
"\"68 Oboe 双簧管\","
"\"69 English Horn 英国管\","
"\"70 Bassoon 巴松管\","
"\"71 Clarinet 单簧管\","

"\"72 Piccolo 短笛\","
"\"73 Flute 长笛\","
"\"74 Recorder 竖笛\","
"\"75 Pan Flute 排笛\","
"\"76 Bottle 吹瓶音\","
"\"77 Shakuhachi 尺八\","
"\"78 Whistle 哨音\","
"\"79 Ocarina 陶笛\","

"\"80 Square Wave 方波\","
"\"81 Saw Wave 锯齿波\","
"\"82 Calliope 管钟琴\","
"\"83 Chiffer Lead 气流主音\","
"\"84 Charang 吉他主音\","
"\"85 Solo Vox 人声主音\","
"\"86 Fifths 五度音\","
"\"87 Bass Lead 低音主音\","

"\"88 New Age Pad 新世纪垫底\","
"\"89 Warm Pad 温暖垫底\","
"\"90 Polysynth 多音合成\","
"\"91 Choir Pad 合唱垫底\","
"\"92 Bowed Pad 弓弦垫底\","
"\"93 Metallic Pad 金属垫底\","
"\"94 Halo Pad 光环垫底\","
"\"95 Sweep Pad 扫弦垫底\","

"\"96 Rain 雨声\","
"\"97 Soundtrack 配乐\","
"\"98 Crystal 水晶音\","
"\"99 Atmosphere 氛围\","
"\"100 Brightness 明亮音色\","
"\"101 Goblins 小妖怪\","
"\"102 Echoes 回声\","
"\"103 Sci-Fi 科幻音\","

"\"104 Sitar 西塔琴\","
"\"105 Banjo 班卓\","
"\"106 Shamisen 三味线\","
"\"107 Koto 筝\","
"\"108 Kalimba 卡林巴琴\","
"\"109 Bagpipe 风笛\","
"\"110 Fiddle 民族小提琴\","
"\"111 Shanai 唢呐\","

"\"112 Tinkle Bell 钟铃\","
"\"113 Agogo 阿高戈\","
"\"114 Steel Drums 钢鼓\","
"\"115 Woodblock 木鱼\","
"\"116 Taiko 太鼓\","
"\"117 Melodic Tom 旋律嗵鼓\","
"\"118 Synth Drum 合成鼓\","
"\"119 Reverse Cymbal 反转镲\","

"\"120 Guitar Fret Noise 吉他滑弦噪音\","
"\"121 Breath Noise 呼吸声\","
"\"122 Seashore 海浪声\","
"\"123 Bird Tweet 鸟鸣\","
"\"124 Telephone 电话铃\","
"\"125 Helicopter 直升机\","
"\"126 Applause 掌声\","
"\"127 Gunshot 枪声\""
"];"

"let sp=document.getElementById('prog');"
"names.forEach((t,i)=>{let o=document.createElement('option');o.value=i;o.textContent=t;sp.appendChild(o);});"
"function setProg(){send('PROG,'+sp.value);}"

// ----------- 音量控制 -----------
"function setVol(){send('VOL,'+document.getElementById('vol').value);}"

// ----------- 钢琴生成 -----------
"let piano=document.getElementById('piano');"
"let white=[0,2,4,5,7,9,11];"
"let black={1:1,3:2,6:4,8:5,10:6};"

"function noteName(n){"
" let nm=['C','C#','D','D#','E','F','F#','G','G#','A','A#','B'];"
" return nm[n%12]+(Math.floor(n/12)-1);"
"}"

"function addEv(k,n){"
" k.onpointerdown=e=>{e.preventDefault();k.classList.add('active');send('ON,'+n);};"
" k.onpointerup=e=>{e.preventDefault();k.classList.remove('active');send('OFF,'+n);};"
" k.onpointerleave=e=>{e.preventDefault();k.classList.remove('active');send('OFF,'+n);};"
"}"

"function build(){"
" let note=21;"
" for(let i=0;i<88;i++){"
"  let p=note%12;"
"  if(white.includes(p)){"
"    let w=document.createElement('div');w.className='white';"
"    let t=document.createElement('div');t.className='label';t.textContent=noteName(note);w.appendChild(t);"
"    addEv(w,note);piano.appendChild(w);"

"    if(black[p]!=undefined){"
"       let b=document.createElement('div');b.className='black';"
"       b.style.left=(40*black[p]-12)+'px';"
"       addEv(b,note+1);w.appendChild(b);"
"    }"
"  }"
"  note++;"
" }"
"}"
"build();"

"</script></body></html>";

// ----------------------------------------------------------------
// Websocket
// ----------------------------------------------------------------
void handleRoot(){
  server.send_P(200,"text/html",INDEX_HTML);
}

void wsEvent(uint8_t num,WStype_t type,uint8_t *payload,size_t len){
  if(type==WStype_TEXT){
    String m=(char*)payload;

    if(m.startsWith("ON")){
      synth.setNoteOn(0, m.substring(3).toInt(), 127);
    }
    else if(m.startsWith("OFF")){
      synth.setNoteOff(0, m.substring(4).toInt(), 0);
    }
    else if(m.startsWith("PROG")){
      synth.setInstrument(0, 0, m.substring(5).toInt());
    }
    else if(m.startsWith("VOL")){
      synth.setControlChange(0, 7, m.substring(4).toInt());
    }
    else if(m=="PANIC"){
      synth.setAllNotesOff(0);
    }
  }
}

void setup(){
  Serial.begin(115200);

  WiFi.softAP(ssid,password);
  WiFi.useStaticBuffers(true);

  synth.begin(&Serial1,XLOT_MIDI_BAUD,UART_TX_PIN ,UART_RX_PIN );
  synth.setInstrument(0,0,0);

  server.on("/",handleRoot);
  server.begin();

  ws.begin();
  ws.onEvent(wsEvent);
}

void loop(){
  server.handleClient();
  ws.loop();
}
